<?php
// BEGIN FUNCTIONS FOR POST FORMATTING *****************************************************************
// Sets page or post title to Untitled if no title found
// Optional argument $rcpi_return determines if title is returned or echoed; defaults to echo
function rucampi_title()
{
	// Get the arguments
	$rcpi_args = func_get_args(); 
	$rcpi_return = (isset($rcpi_args[0]) && $rcpi_args[0] ? true : false);
	
	// Return or echo the date
	$rcpi_title = the_title('', '', false);
	apply_filters('rucampi_title', $rcpi_title);

	if ($rcpi_return) {
		return ($rcpi_title ? $rcpi_title : 'Untitled');
	} else {
		echo ($rcpi_title ? $rcpi_title : 'Untitled');
	}
	
} // End function

// Appends a "Read more" link to excerpts
function rucampi_excerpt_more($more)
{
	global $post;
	return ' ... <a href="'. get_permalink($post->ID) . '">Read more ...</a>';
	
} // End function

add_filter('excerpt_more', 'rucampi_excerpt_more');

// Returns a title with link
function rucampi_concat_title($title, $link)
{
	global $post;
	
	$rcpi_string = ($title ? '<h3 class="rcpi-title">' : ''); // Open title
	$rcpi_string = $rcpi_string.($title && $link ? '<a href="'.get_permalink().'">' : ''); // Open link
	$rcpi_string = $rcpi_string.($title ? rucampi_title(true) : ''); // Title
	$rcpi_string = $rcpi_string.($title && $link ? '</a>' : ''); // Close link
	$rcpi_string = $rcpi_string.($title ? '</h3>'."\n\t" : ''); // Close title
	return $rcpi_string;
}

// Returns a post thumbnail, excerpt and postdate
function rucampi_concat_body($thumb, $excerpt, $postdate)
{
	global $post;
	
	$rcpi_string = ($thumb && has_post_thumbnail() ? get_the_post_thumbnail()."\n\t" : ''); // Thumbnail
	$rcpi_string = $rcpi_string.($excerpt ? '<div class="rcpi-excerpt">'.get_the_excerpt().'</div>'."\n\t" : ''); // Excerpt
	$rcpi_string = $rcpi_string.($postdate ? '<div class="rcpi-created">Posted '.rucampi_date(true, 'post').'</div>'."\n\t" : ''); // Create date
	return $rcpi_string;
}

// Returns a div to clear floats
function rucampi_return_clear($clear)
{
	return ($clear ? '<div style="clear: both;"></div>'."\n" : '');
}

?>