<?php
// BEGIN FUNCTIONS FOR CUSTOM POST DISPLAYS ************************************************************
// Retrieves most recent published post and displays for designated number of hours; does not expire if post is sticky
function rucampi_display_alert($atts, $content = null)
{
	global $post;
	
	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'hours' => 0,					// Number of hours for which the post should display
		'label' => '',					// String to prefix title of post; appears within title's HTML tag
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 0,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 'time',			// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-alert-post'	// Class of post container
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, array('ID', 'author', 'title', 'modified', 'parent', 'rand')) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$hours = (is_numeric($hours) ? $hours : 0);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '1' || $thumb === 1 ? 1 : 0);
	$postdate = ($postdate == 'date' || $postdate === '0' || $postdate === 0 ? $postdate : 'time');
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-alert-post');

	// Determine if hours are set; if so, calculate
	if ($hours) {
		$now = time();
		$start = $now - ($hours * 60 * 60);
	}

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$alerts = get_posts($args);

	// Build post
	$string = '';
	foreach ($alerts as $post) {
		setup_postdata($post);
		$posted = get_post_time('U', true);
	
		// Check time/sticky status before displaying
		if (is_sticky() || ($hours && $posted >= $start)) {
			
			// Concat the post
			$string = $string.'<div id="alert-post-'.get_the_ID().'" class="'.$class.'">'."\n\t";
			$string = $string.'<h3 class="rcpi-title">'.$label.'<a href="'.get_permalink().'">'.rucampi_title(true).'</a></h3>'."\n\t"; // Title and permalink
			$string = $string.($thumb && has_post_thumbnail() ? get_the_post_thumbnail()."\n\t" : ''); // Thumbnail
			$string = $string.($excerpt ? '<div class="rcpi-excerpt">'.get_the_excerpt().'</div>'."\n\t" : ''); // Excerpt
			$string = $string.($postdate ? '<div class="rcpi-created">Posted' : ''); // Open create date
			$string = $string.($postdate == 'time' ? ' at '.rucampi_time(true, 'post') : ''); // Create time
			$string = $string.($postdate ? ' '.rucampi_date(true, 'post').'</div>'."\n" : ''); // Close create date
			$string = $string.'</div>'."\n";
			$string = $string.($clear ? '<div style="clear: both;"></div>'."\n" : ''); // Append div to clear floats

		} // End check of time/sticky status
	} // Next post
	
	apply_filters('rucampi_display_alert', $string);
	return $string;
	
} // End function
add_shortcode('alertpost', 'rucampi_display_alert');

// Retrieves most recent published post and displays for designated number of days
function rucampi_display_dated($atts, $content = null)
{
	global $post;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'days' => 0,					// Number of days for which the post should display
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-series-post'	// Class of post container
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, array('ID', 'author', 'title', 'modified', 'parent', 'rand')) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$days = (is_numeric($days) ? $days : 0);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-series-post');

	// Determine if days are set; if so, calculate
	if ($days) {
		$now = time();
		$start = $now - ($days * 24 * 60 * 60);
	}

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$series = get_posts($args);

	// Build post
	$string = '';
	foreach ($series as $post) {
		setup_postdata($post);
		$posted = get_post_time('U', true);
	
		// Check time before displaying
		if ($days && $posted >= $start) {
			$string = $string.'<div id="new-post-'.get_the_ID().'" class="'.$class.'">'."\n\t";
			$string = $string.rucampi_concat_title($title, $link).rucampi_concat_body($thumb, $excerpt, $postdate).rucampi_return_clear($clear)."</div>\n";
		} // End check of time
	
	} // Next post
	
	apply_filters('rucampi_display_dated', $string);
	return $string;
	
} // End function
add_shortcode('datedpost', 'rucampi_display_dated');

// Retrieves most recent published post and displays if post month is current month
function rucampi_display_monthly($atts, $content = null)
{
	global $post;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 0,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-monthly-post'	// Class of post container
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, array('ID', 'author', 'title', 'modified', 'parent', 'rand')) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '1' || $thumb === 1 ? 1 : 0);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-monthly-post');

	// Get the current month and year
	$now = time();
	$thismonth = date('n|Y', $now);

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$monthly = get_posts($args);

	// Build post if current month/year match post month/year
	$string = '<div class="'.$class.'-group">'."\n\t";
	$string = $string.($label ? '<div class="rcpi-label">'.$label.'</div>'."\n\t" : ''); // Label
	
	foreach ($monthly as $post) {
		setup_postdata($post); //
		$posted = get_post_time('U', true);
		$postmonth = date('n|Y', $posted);
	
		// Check time/sticky status before displaying
		if ($thismonth == $postmonth) {
			$string = $string.'<div id="monthly-post-'.get_the_ID().'" class="'.$class.'">'."\n\t";
			$string = $string.rucampi_concat_title($title, $link).rucampi_concat_body($thumb, $excerpt, $postdate).rucampi_return_clear($clear)."</div>\n";
		} // End check of time/sticky status
	
	} // Next post
	
	$string = $string.'</div>'."\n";
	apply_filters('rucampi_display_monthly', $string);
	return $string;
	
} // End function
add_shortcode('monthlypost', 'rucampi_display_monthly');

// Retrieves and displays most recent posts; default is one post; ignores sticky post status
function rucampi_display_new($atts, $content = null)
{
	global $post;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-new-post'		// Class of post container
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, array('ID', 'author', 'title', 'modified', 'parent', 'rand')) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-new-post');

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$newposts = get_posts($args);
	
	// Build posts
	$string = '<div class="'.$class.'-group">'."\n\t";
	$string = $string.($label ? '<div class="rcpi-label">'.$label.'</div>'."\n\t" : ''); // Label

	foreach ($newposts as $post) {
		setup_postdata($post);
		$string = $string.'<div id="new-post-'.get_the_ID().'" class="'.$class.'">'."\n\t";
		$string = $string.rucampi_concat_title($title, $link).rucampi_concat_body($thumb, $excerpt, $postdate).rucampi_return_clear($clear)."</div>\n";
	} // Next post
	
	$string = $string.'</div>'."\n";
	apply_filters('rucampi_display_new', $string);
	return $string;

} // End function
add_shortcode('newpost', 'rucampi_display_new');

// Displays a random published post; ignores sticky post status
function rucampi_display_random($atts, $content = null)
{
	global $post;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'number' => 1,					// Number of posts to display
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-random-post'	// Class of post container
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-random-post');

	// Set function args and get the post
	$args = array('numberposts' => $number, 'orderby' => 'rand');
	if ($category) {$args['category'] = $category;}
	$random = get_posts($args);

	// Display random post
	$string = '';
	foreach ($random as $post) {
		setup_postdata($post);
		
		// Concat the post
		$string = $string.'<div id="random-post-'.get_the_ID().'" class="'.$class.'">'."\n\t";
		$string = $string.($label ? '<div class="rcpi-label">'.$label.'</div>'."\n\t" : ''); // Label
		$string = $string.rucampi_concat_title($title, $link).rucampi_concat_body($thumb, $excerpt, $postdate)."</div>\n".rucampi_return_clear($clear);	

	} // Next post
	
	apply_filters('rucampi_display_random', $string);
	return $string;
	
} // End function
add_shortcode('randompost', 'rucampi_display_random');
?>