<?php
// BEGIN FUNCTIONS FOR DATE/TIME FORMATS ***************************************************************
// Set the local time zone based on the WordPress settings
$rcpi_localtime = get_option('gmt_offset');
putenv("TZ=".$rcpi_localtime);

// Returns the month name corresponding to the month number
function rucampi_return_month($rcpi_month) 
{
	$rcpi_monthnames = array(0, 'Jan. ', 'Feb. ', 'March ', 'April ', 'May ', 'June ', 'July ', 'Aug. ', 'Sept. ', 'Oct. ', 'Nov. ', 'Dec. ');
	return $rcpi_monthnames[$rcpi_month];
}

// Return or echo a post create date, post lasmod date or comment date
// Optional argument $rcpi_return determines if title is returned or echoed; defaults to echo
function rucampi_date()
{
	// Get the arguments
	$rcpi_args = func_get_args(); 
	$rcpi_return = (isset($rcpi_args[0]) && $rcpi_args[0] ? true : false);
	$rcpi_type = (isset($rcpi_args[1]) && in_array($rcpi_args[1], array('comment', 'mod')) ? $rcpi_args[1] : 'post'); 
	
	// Get the values based on type
	if ($rcpi_type == 'post') {
		$rcpi_month = get_the_time('n');
		$rcpi_year = get_the_time('Y');	
		$rcpi_today = get_the_time('F j Y');
		$rcpi_day = get_the_time('j');
	} else if ($rcpi_type == 'mod') {
		$rcpi_month = get_the_modified_date('n');
		$rcpi_year = get_the_modified_time('Y');
		$rcpi_today = get_the_modified_date('F j Y');
		$rcpi_day = get_the_modified_time('j');
	} else {
		$rcpi_month = get_comment_time('n');
		$rcpi_year = get_comment_time('Y');
		$rcpi_today = get_comment_time('F j Y');
		$rcpi_day = get_comment_time('j');
	}
	
	// Format month and year; determine if date is "today"; set final date format
	$rcpi_month_string = rucampi_return_month($rcpi_month);
	$rcpi_year_string = ', '.$rcpi_year;
	$rcpi_today_string = ($rcpi_today == date('F j Y') ? 'today' : '');
	$rcpi_fulldate = ($rcpi_today_string ? $rcpi_today_string : $rcpi_month_string.$rcpi_day.$rcpi_year_string);
	
	apply_filters('rucampi_date', $rcpi_fulldate);
	
	// Return or echo the date
	if ($rcpi_return) {
		return $rcpi_fulldate;
	} else {
		echo $rcpi_fulldate;
	}
	
} // End function

// Return or echo a post create time, post lasmod time or comment time
function rucampi_time()
{
	// Get the arguments
	$rcpi_args = func_get_args(); 
	$rcpi_return = (isset($rcpi_args[0]) && $rcpi_args[0] ? true : false);
	$rcpi_type = (isset($rcpi_args[1]) && in_array($rcpi_args[1], array('comment', 'mod')) ? $rcpi_args[1] : 'post'); 

	// Get the values based on type
	if ($rcpi_type == 'post') {
		$rcpi_meridian = get_the_time('a');
		$rcpi_mid = get_the_time('H:i');
	} else if ($rcpi_type == 'mod') {
		$rcpi_meridian = get_the_modified_time('a');
		$rcpi_mid = get_the_modified_time('H:i');
	} else {
		$rcpi_meridian = get_comment_time('a');
		$rcpi_mid = get_comment_time('H:i');
	}
	
	// Format the full time
	if ($rcpi_mid == '00:00') {
		$rcpi_fulltime = 'midnight';
	} else if ($rcpi_mid == '12:00') {
		$rcpi_fulltime = 'noon';
	} else {
		$rcpi_fulltime = str_replace(':00', '', $rcpi_mid).' '.str_replace('m', '.m.', $rcpi_meridian);
	}
	
	apply_filters('rucampi_time', $rcpi_fulltime);
	
	// Return or echo the time
	if ($rcpi_return) {
		return $rcpi_fulltime;
	} else {
		echo $rcpi_fulltime;
	}
	
} // End function

// Return or echo a post create date and time, post lasmod date and time or comment date and time
function rucampi_datetime()
{
	// Get the arguments
	$rcpi_args = func_get_args(); 
	$rcpi_return = (isset($rcpi_args[0]) && $rcpi_args[0] ? true : false);
	$rcpi_type = (isset($rcpi_args[1]) && in_array($rcpi_args[1], array('comment', 'mod')) ? $rcpi_args[1] : 'post'); 
	
	// Call date and time functions to concat date/time
	$rcpi_datetime = rucampi_time(true, $rcpi_type).' '.rucampi_date(true, $rcpi_type);
	apply_filters('rucampi_datetime', $rcpi_datetime);
	
	// Return or echo the date/time
	if ($rcpi_return) {
		return $rcpi_datetime;
	} else {
		echo $rcpi_datetime;
	}
	
} // End function
?>