<?php
/*
Plugin Name: RUCAM Shortcodes
Description: Shortcodes for inline posts, links, feeds and other features.
Version: 1.0
Author: Susan Walker
Author URI: http: //computing.camden.rutgers.edu
License: For use on Rutgers University Wordpress sites. Not for general release.
*/
?>
<?php
// ATTACH STYLESHEETS TO THEME *************************************************************************
	//wp_enqueue_style( $handle, $src, $deps, $ver, $media );
	
	
// BEGIN FUNCTIONS FOR CUSTOM POST DISPLAYS ************************************************************
// Retrieves most recent published post and displays for designated number of hours; does not expire if post is sticky
function rucam_sc_display_alert($atts, $content = null)
{
	global $post;
		
	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'hours' => 0,					// Number of hours for which the post should display
		'label' => '',					// String to prefix title of post; appears within title's HTML tag
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 0,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 'time',			// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcsc-alert-post'	// Class of post container
	), $atts));
	
	// Check and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$hours = (is_numeric($hours) ? $hours : 0);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '1' || $thumb === 1 ? 1 : 0);
	$postdate = ($postdate == 'date' || $postdate === '0' || $postdate === 0 ? $postdate : 'time');
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcsc-alert-post');
	
	// Determine if hours are set; if so, calculate
	if ($hours) {
		$now = time();
		$start = $now - ($hours * 60 * 60);
	}
	
	// Set function args and get the post
	$args = array('numberposts' => 1);
	if ($category) {$args['category'] = $category;}
	$alerts = get_posts($args);
	
	// Display post
	foreach ($alerts as $post) {
		setup_postdata($post);
		$posted = get_post_time('U', true);
		
		// Check time/sticky status before displaying
		if (is_sticky() || ($hours && $posted >= $start)) {
?>
		<div id="alert-post-<?php the_ID(); ?>" class="<?php echo $class; ?>">
			<h3 class="rcsc-title"><?php echo $label; ?><a href="<?php the_permalink(); ?>"><?php rucam_title(); ?></a></h3>
            <?php if ($thumb && has_post_thumbnail()) : the_post_thumbnail(); endif; ?>
			<?php if ($excerpt) : ?><div class="rcsc-excerpt"><?php the_excerpt(); ?></div><?php endif; ?>
            <?php if ($postdate) : ?><div class="rcsc-created">Posted <?php if ($postdate == 'time') : ?>at <?php rucam_create_time(); ?><?php endif; ?> <?php rucam_create_date(); ?></div><?php endif; ?>
        </div>
        <?php if ($clear) : ?><div style="clear: both;"></div><?php endif; ?>
<?php
		} // End check of time/sticky status
	} // Next alert
}
add_shortcode('alertpost', 'rucam_sc_display_alert');

// Retrieves most recent published post and displays for designated number of days
function rucam_sc_display_series($atts, $content = null)
{
	global $post;
	
	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'days' => 0,					// Number of days for which the post should display
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post title: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcsc-series-post'	// Class of post container
	), $atts));
	
	// Check and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$days = (is_numeric($days) ? $days : 0);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcsc-series-post');
	
	// Determine if days are set; if so, calculate
	if ($days) {
		$now = time();
		$start = $now - ($days * 24 * 60 * 60);
	}
	
	// Set function args and get the post
	$args = array('numberposts' => 1);
	if ($category) {$args['category'] = $category;}
	$series = get_posts($args);
	
	// Display post
	foreach ($series as $post) {
		setup_postdata($post);
		$posted = get_post_time('U', true);
		
		// Check time before displaying
		if ($days && $posted >= $start) {
?>
		<div id="series-post-<?php the_ID(); ?>" class="<?php echo $class; ?>">
        	<?php if ($label) : ?><div class="rcsc-label"><?php echo $label; ?></div><?php endif; ?>
			<?php if ($title) : ?><h3 class="rcsc-title"><?php if ($link) : ?><a href="<?php the_permalink(); ?>"><?php endif; ?><?php rucam_title(); ?><?php if ($link) : ?></a><?php endif; ?></h3><?php endif; ?>
            <?php if ($thumb && has_post_thumbnail()) : the_post_thumbnail(); endif; ?>
			<?php if ($excerpt) : ?><div class="rcsc-excerpt"><?php the_excerpt(); ?></div><?php endif; ?>
            <?php if ($postdate) : ?><div class="rcsc-created">Posted <?php rucam_create_date(); ?></div><?php endif; ?>
        </div>
        <?php if ($clear) : ?><div style="clear: both;"></div><?php endif; ?>
<?php
		} // End check of time
	} // Next
}
add_shortcode('seriespost', 'rucam_sc_display_series');

// Retrieves most recent published post and displays if post month is current month
function rucam_sc_display_monthly($atts, $content = null)
{
	global $post;
	
	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post title: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 0,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcsc-monthly-post'	// Class of post container
	), $atts));
	
	// Check and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '1' || $thumb === 1 ? 1 : 0);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcsc-monthly-post');
	
	// Get the current month and year
	$now = time();
	$thismonth = date('n|Y', $now);
	
	// Set function args and get the post
	$args = array('numberposts' => 1);
	if ($category) {$args['category'] = $category;}
	$monthly = get_posts($args);
	
	// Display post if current month/year match post month/year
	foreach ($monthly as $post) {
		setup_postdata($post); //
		$posted = get_post_time('U', true);
		$postmonth = date('n|Y', $posted);
		
		// Check time/sticky status before displaying
		if ($thismonth == $postmonth) {
?>
		<div id="monthly-post-<?php the_ID(); ?>" class="<?php echo $class; ?>">
        	<?php if ($label) : ?><div class="rcsc-label"><?php echo $label; ?></div><?php endif; ?>
			<?php if ($title) : ?><h3 class="rcsc-title"><?php if ($link) : ?><a href="<?php the_permalink(); ?>"><?php endif; ?><?php rucam_title(); ?><?php if ($link) : ?></a><?php endif; ?></h3><?php endif; ?>
            <?php if ($thumb && has_post_thumbnail()) : the_post_thumbnail(); endif; ?>
			<?php if ($excerpt) : ?><div class="rcsc-excerpt"><?php the_excerpt(); ?></div><?php endif; ?>
            <?php if ($postdate) : ?><div class="rcsc-created">Posted <?php rucam_create_date(); ?></div><?php endif; ?>
        </div>
        <?php if ($clear) : ?><div style="clear: both;"></div><?php endif; ?>
<?php
		} // End check of time/sticky status
	} // Next
}
add_shortcode('monthlypost', 'rucam_sc_display_monthly');

// Retrieves and displays most recent posts; default is one post; ignores sticky post status
function rucam_sc_display_new($atts, $content = null)
{
	global $post;
	
	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'number' => 1,					// Number of posts to display
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post title: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcsc-new-post'		// Class of post container
	), $atts));
	
	// Check and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcsc-new-post');
	
	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	$newposts = get_posts($args);
	
?>
	<div class="<?php echo $class; ?>-group">
		<?php if ($label) : ?><div class="rcsc-label"><?php echo $label; ?></div><?php endif; ?>
<?php
	
	// Display post
	foreach ($newposts as $post) {
		setup_postdata($post);
		
?>
			<div id="new-post-<?php the_ID(); ?>" class="<?php echo $class; ?>">
				<?php if ($title) : ?><h3 class="rcsc-title"><?php if ($link) : ?><a href="<?php the_permalink(); ?>"><?php endif; ?><?php rucam_title(); ?><?php if ($link) : ?></a><?php endif; ?></h3><?php endif; ?>
            	<?php if ($thumb && has_post_thumbnail()) : the_post_thumbnail(); endif; ?>
				<?php if ($excerpt) : ?><div class="rcsc-excerpt"><?php the_excerpt(); ?></div><?php endif; ?>
            	<?php if ($postdate) : ?><div class="rcsc-created">Posted <?php rucam_create_date(); ?></div><?php endif; ?>
        	</div>
        	<?php if ($clear) : ?><div style="clear: both;"></div><?php endif; ?>
<?php
	} // Next
?>
	</div>
<?php
}
add_shortcode('newpost', 'rucam_sc_display_new');

// Displays a random published post; ignores sticky post status
function rucam_sc_display_random($atts, $content = null)
{
	global $post;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post title: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcsc-random-post'	// Class of post container
	), $atts));
	
	// Check and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcsc-random-post');
	
	// Set function args and get the post
	$args = array('numberposts' => 1, 'orderby' => 'rand');
	if ($category) {$args['category'] = $category;}
	$random = get_posts($args);
	
	// Display random post
	foreach ($random as $post) {
		setup_postdata($post);
		
?>
		<div id="random-post-<?php the_ID(); ?>" class="<?php echo $class; ?>">
        	<?php if ($label) : ?><div class="rcsc-label"><?php echo $label; ?></div><?php endif; ?>
			<?php if ($title) : ?><h3 class="rcsc-title"><?php if ($link) : ?><a href="<?php the_permalink(); ?>"><?php endif; ?><?php rucam_title(); ?><?php if ($link) : ?></a><?php endif; ?></h3><?php endif; ?>
            <?php if ($thumb && has_post_thumbnail()) : the_post_thumbnail(); endif; ?>
			<?php if ($excerpt) : ?><div class="rcsc-excerpt"><?php the_excerpt(); ?></div><?php endif; ?>
            <?php if ($postdate) : ?><div class="rcsc-created">Posted <?php rucam_create_date(); ?></div><?php endif; ?>
        </div>
        <?php if ($clear) : ?><div style="clear: both;"></div><?php endif; ?>
<?php

	} // Next	
}
add_shortcode('randompost', 'rucam_sc_display_random');
?>