<?php
// BEGIN FUNCTIONS FOR DATE/TIME FORMATS ***************************************************************
// Set the local time zone based on the WordPress settings
$the_localtime = get_option('gmt_offset');
putenv("TZ=".$the_localtime);

// Returns the month name corresponding to the month number
function rucampi_return_month($month_no) 
{
	$month_abb = array(0, 'Jan. ', 'Feb. ', 'March ', 'April ', 'May ', 'June ', 'July ', 'Aug. ', 'Sept. ', 'Oct. ', 'Nov. ', 'Dec. ');
	return $month_abb[$month_no];
}

// Return or echo a post create date, post lasmod date or comment date
// Optional argument $return determines if title is returned or echoed; defaults to echo
function rucampi_date()
{
	// Get the arguments
	$args = func_get_args(); 
	$return = (isset($args[0]) && $args[0] ? true : false);
	$content_type = (isset($args[1]) && in_array($args[1], array('comment', 'mod')) ? $args[1] : 'post'); 
	
	// Get the values based on type
	if ($content_type == 'post') {
		$month_no = get_the_time('n');
		$year_no = get_the_time('Y');	
		$date_no = get_the_time('F j Y');
		$day_no = get_the_time('j');
	} else if ($content_type == 'mod') {
		$month_no = get_the_modified_date('n');
		$year_no = get_the_modified_time('Y');
		$date_no = get_the_modified_date('F j Y');
		$day_no = get_the_modified_time('j');
	} else {
		$month_no = get_comment_time('n');
		$year_no = get_comment_time('Y');
		$date_no = get_comment_time('F j Y');
		$day_no = get_comment_time('j');
	}
	
	// Format month and year; determine if date is "today"; set final date format
	$month_string = rucampi_return_month($month_no);
	$year_string = ', '.$year_no;
	$date_string = ($date_no == date('F j Y') ? 'today' : '');
	$full_date = ($date_string ? $date_string : $month_string.$day_no.$year_string);
	
	apply_filters('rucampi_date', $full_date);
	
	// Return or echo the date
	if ($return) {
		return $full_date;
	} else {
		echo $full_date;
	}
	
} // End function

// Return or echo a post create time, post lasmod time or comment time
function rucampi_time()
{
	// Get the arguments
	$args = func_get_args(); 
	$return = (isset($args[0]) && $args[0] ? true : false);
	$content_type = (isset($args[1]) && in_array($args[1], array('comment', 'mod')) ? $args[1] : 'post'); 

	// Get the values based on type
	if ($content_type == 'post') {
		$meridian = get_the_time('a');
		$time_no = get_the_time('g:i');
	} else if ($content_type == 'mod') {
		$meridian = get_the_modified_time('a');
		$time_no = get_the_modified_time('g:i');
	} else {
		$meridian = get_comment_time('a');
		$time_no = get_comment_time('g:i');
	}
	
	// Format the full time
	if ($time_no == '00:00') {
		$full_time = 'midnight';
	} else if ($time_no == '12:00') {
		$full_time = 'noon';
	} else {
		$full_time = str_replace(':00', '', $time_no).' '.str_replace('m', '.m.', $meridian);
	}
	
	apply_filters('rucampi_time', $full_time);
	
	// Return or echo the time
	if ($return) {
		return $full_time;
	} else {
		echo $full_time;
	}
	
} // End function

// Return or echo a post create date and time, post lasmod date and time or comment date and time
function rucampi_datetime()
{
	// Get the arguments
	$args = func_get_args(); 
	$return = (isset($args[0]) && $args[0] ? true : false);
	$content_type = (isset($args[1]) && in_array($args[1], array('comment', 'mod')) ? $args[1] : 'post'); 
	
	// Call date and time functions to concat date/time
	$date_time = rucampi_time(true, $content_type).' '.rucampi_date(true, $content_type);
	apply_filters('rucampi_datetime', $date_time);
	
	// Return or echo the date/time
	if ($return) {
		return $date_time;
	} else {
		echo $date_time;
	}
	
} // End function
?>