<?php
// BEGIN GENERAL FUNCTIONS FOR CONTENT OUTPUT **********************************************************
// Returns a div to clear floats
function rucampi_return_clear($clear)
{
	return ($clear ? '<div style="clear: both;"></div>'."\n" : '');
}
add_shortcode('clearall', 'rucampi_return_clear');

// BEGIN FUNCTIONS FOR POST OUTPUT *********************************************************************
// Returns a title with link; sets HTML tag for title
function rucampi_concat_title($tag, $label, $title, $link)
{
	global $post;
	
	$string = ($title ? "\t".'<'.$tag.' class="rcpi-title">' : ''); // Open title
	$string = $string.($label ? '<span class="rcpi-label">'.$label.'</span>' : ''); // Prepend label
	$string = $string.($title && $link ? '<a href="'.get_permalink().'" title="read the full post">' : ''); // Open link
	$string = $string.($title ? get_the_title() : ''); // Title
	$string = $string.($title && $link ? '</a>' : ''); // Close link
	$string = $string.($title ? '</'.$tag.'>'."\n" : ''); // Close title
	return $string;
}

// Returns a post thumbnail, excerpt and postdate
function rucampi_concat_body($thumb, $excerpt, $postdate)
{
	global $post;
	
	$string = ($thumb && has_post_thumbnail() ? get_the_post_thumbnail()."\n" : ''); // Thumbnail
	$string = $string.($excerpt ? "\t".'<div class="rcpi-excerpt">'.get_the_excerpt().'</div>'."\n" : ''); // Excerpt
	$string = $string.($postdate ? "\t".'<div class="rcpi-created">Posted '.rucampi_date(true).'</div>'."\n" : ''); // Create date
	return $string;
}
?>