<?php
// SET VARIABLES FOR CUSTOM LLINK DISPLAYS *************************************************************
$rcpi_link_orderbys = array('link_id', 'length', 'description', 'name', 'owner', 'rating', 'url', 'rand');
$rcpi_linkcat_orderbys = array('name', 'id', 'slug', 'count');
$rcpi_link_tags = array('h2', 'h3', 'h4', 'h5', 'h6', 'p', 'div');

// BEGIN FUNCTIONS FOR CUSTOM LINK DISPLAYS ************************************************************
// Displays list of links by category; uses My Link Order to order links and categories if plugin is available, default if not
function rucampi_links_block($atts, $content = null)
{
	global $rcpi_link_orderbys, $rcpi_linkcat_orderbys, $rcpi_link_tags;
	
	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designates categories to list (comma-sepaated list if more than one); pulls from all categories if none is set
		'limit' => -1,					// Maximum number to display
		'orderby' => 'order',			// Field to order links by
		'order' => false,				// Link order
		'category_orderby' => 'order',	// Field to order categories by
		'category_order' => false,		// Category order
		'show_description' => 0,		// Display link description
		'align' => '',					// Alignment: right or left
		'width' => '',					// Number, up to 100
		'margin' => '',					// Margin around container
		'colorclass' => '',				// Sets appearance of elements within list
		'tag' => 'h3',					// Category tag
		'linktext' => 'More links',		// Link text, if block will link to resources elsewhere
		'linkurl' => '',				// Link URL, if block will link to resources elsewhere
		'clear' => 0					// Clear float
	), $atts));
	
	// Check and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$limit = (is_numeric($limit) && floor($limit) > 0 ? floor($limit) : -1);
	$orderby = (in_array($orderby, $rcpi_link_orderbys) ? $orderby : 'order');
	$order = ($order == 'DESC' ? $order : 'ASC');
	$category_orderby = (in_array($category_orderby, $rcpi_linkcat_orderbys) ? $category_orderby : 'order');
	$category_order = ($category_order == 'DESC' ? $category_order : 'ASC');
	$show_description = ($show_description === '1' || $show_description === 1 ? 1 : 0);
	$align = ($align ? $align.'-' : '');
	$width = (is_numeric($width) && floor($width) <= 100 ? ' style="width: '.floor($width).'%;"' : '');	
	$margin = ($margin ? ' style="margin: '.$margin.';"' : '');
	$colorclass = ($colorclass ? $colorclass : '');
	$tag = (in_array($tag, $rcpi_link_tags) ? $tag : 'h3');
	$linktext = ($linktext ? $linktext : 'More links');
	$linkurl = $linkurl;
	$bottom = ($linkurl ? '' : ' rcpi-list-end');
	$clear = ($clear === '1' || $clear === 1 ? 1 : 0);
	
	// Open the containers
	$string = '<div class="rcpi-'.$align.'linkgroup-wrapper"'.$width.'>'."\n";
	$string = $string."\t".'<div class="rcpi-'.$align.'linkgroup-content"'.$margin.'>'."\n";
	$string = $string.($colorclass ? "\t\t".'<div class="'.$colorclass.' rcpi-links-block">'."\n" : '');

	// Set up arguments
	$args = array(
		'order' => $order,
		'category_order' => $category_order,
		'show_description' => $show_description,
		'title_before' => '<'.$tag.' class="rcpi-links-title">', 
		'title_after' => '</'.$tag.'>'."\n\t".'<div class="rcpi-links-group'.$bottom.'">'."\n", 
		'category_before' => '<a name=%id></a>',
		'category_after' => '</div>'."\n",
		'echo' => 0
	);
	
	// Add conditional arguments
	if ($category) {$args['category'] = $category;} 
	if ($limit != -1) {$args['limit'] = $limit;}
			
	// Adjust orderby values; call function and append list to string
	if (function_exists('mylinkorder_list_bookmarks')) {
		$args['orderby'] = $orderby;
		$args['category_orderby'] = $category_orderby;		
		$string = $string.mylinkorder_list_bookmarks($args); 
	} else {
		if ($orderby != 'order') {$args['orderby'] = $orderby;}
		if ($category_orderby != 'order') {$args['category_orderby'] = $category_orderby;}
		$string = $string.wp_list_bookmarks($args);
	} // End check for function
	
	// Close the containers
	$string = $string.($linktext && $linkurl ? "\t\t".'<p class="rcpi-links-more"><a href="'.$linkurl.'">'.$linktext.'</a></p>'."\n" : '');
	$string = $string.($colorclass ? "\t\t</div>\n" : '')."\t</div>\n</div>\n".rucampi_return_clear($clear);
	
	apply_filters('rucampi_links_block', $string);
	return $string;
	
} // End function
add_shortcode('linksblock', 'rucampi_links_block');
?>