<?php

// SET VARIABLES FOR CUSTOM POST DISPLAYS **************************************************************
$rcpi_post_orderbys = array('ID', 'author', 'title', 'modified', 'parent', 'rand');
$rcpi_post_tags = array('h2', 'h3', 'h4', 'h5', 'h6', 'p', 'div');
$rcpi_post_types = array('post', 'newsletter', 'faq');

// BEGIN FUNCTIONS FOR CUSTOM POST DISPLAYS ************************************************************
// Retrieves most recent published post and displays for designated number of hours; does not expire if post is sticky
function rucampi_display_alert($atts, $content = null)
{
	global $post, $rcpi_post_orderbys, $rcpi_post_tags, $rcpi_post_types;
	
	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'post_type' => false,			// Post type
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'hours' => 0,					// Number of hours for which the post should display
		'label' => '',					// String to prefix title of post; appears within title's HTML tag
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 0,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 'time',			// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-alert-post',	// Class of post container
		'tag' => 'h3'					// Tag to use for post title
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$post_type = (in_array($post_type, $rcpi_post_types) ? $post_type : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, $rcpi_post_orderbys) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$hours = (is_numeric($hours) ? $hours : 0);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '1' || $thumb === 1 ? 1 : 0);
	$postdate = ($postdate == 'date' || $postdate === '0' || $postdate === 0 ? $postdate : 'time');
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-alert-post');
	$tag = (in_array($tag, $rcpi_post_tags) ? $tag : 'h3');

	// Determine if hours are set; if so, calculate start point
	if ($hours) {
		$start = time() - ($hours * 60 * 60);
	}

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($post_type) {$args['post_type'] = $post_type;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$alerts = get_posts($args);

	// Build post
	$string = '';
	foreach ($alerts as $post) {
		setup_postdata($post);
		$posted = get_post_time('U', true);
	
		// Check time/sticky status; concat post if current
		if (is_sticky() || ($hours && $posted >= $start)) {
			$string = $string.'<div id="alert-post-'.get_the_ID().'" class="'.$class.'">'."\n\t";
			$string = $string.rucampi_concat_title($tag, $label, true, true);			
			$string = $string.($thumb && has_post_thumbnail() ? get_the_post_thumbnail()."\n\t" : ''); // Thumbnail
			$string = $string.($excerpt ? '<div class="rcpi-excerpt">'.get_the_excerpt().'</div>'."\n\t" : ''); // Excerpt
			$string = $string.($postdate ? '<div class="rcpi-created">Posted' : ''); // Open create date
			$string = $string.($postdate == 'time' ? ' at '.rucampi_time(true, 'post') : ''); // Create time
			$string = $string.($postdate ? ' '.rucampi_date(true, 'post').'</div>'."\n" : ''); // Close create date
			$string = $string.'</div>'."\n".rucampi_return_clear($clear);
		} // End check of time/sticky status
	} // Next post
	
	apply_filters('rucampi_display_alert', $string);
	return $string;
	
} // End function
add_shortcode('alertpost', 'rucampi_display_alert');

// Retrieves most recent published post and displays for designated number of days
function rucampi_display_dated($atts, $content = null)
{
	global $post, $rcpi_post_orderbys, $rcpi_post_tags, $rcpi_post_types;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'post_type' => false,			// Post type
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'days' => 1,					// Number of days for which the post should display
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-dated-post',	// Class of post container
		'tag' => 'h3'					// Tag to use for post title

	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$post_type = (in_array($post_type, $rcpi_post_types) ? $post_type : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, $rcpi_post_orderbys) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$days = (is_numeric($days) ? $days : 1);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-dated-post');
	$tag = (in_array($tag, $rcpi_post_tags) ? $tag : 'h3');

	// Determine if days are set; if so, calculate start point
	if ($days) {
		$start = time() - ($days * 24 * 60 * 60);
	}

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($post_type) {$args['post_type'] = $post_type;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$series = get_posts($args);

	// Build post
	$string = '';
	foreach ($series as $post) {
		setup_postdata($post);
		$posted = get_post_time('U', true);
	
		// Check time before displaying
		if ($days && $posted >= $start) {
			$string = $string.'<div id="dated-post-'.get_the_ID().'" class="'.$class.'">'."\n\t"; // Open the container
			$string = $string.rucampi_concat_title($tag, $label, $title, $link).rucampi_concat_body($thumb, $excerpt, $postdate); // The post
			$string = $string."</div>\n".rucampi_return_clear($clear); // Close container and append div to clear, if set
		} // End check of time
	
	} // Next post
	
	apply_filters('rucampi_display_dated', $string);
	return $string;
	
} // End function
add_shortcode('datedpost', 'rucampi_display_dated');


// Retrieves most recent published post and displays title for designated number of days
function rucampi_display_headline($atts, $content = null)
{
	global $post, $rcpi_post_orderbys, $rcpi_post_tags, $rcpi_post_types;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'days' => 1,					// Number of days for which the post should display
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-headline-post',	// Class of post container
		'tag' => 'h3'					// Tag to use for post title

	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, $rcpi_post_orderbys) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$days = (is_numeric($days) ? $days : 1);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-headline-post');
	$tag = (in_array($tag, $rcpi_post_tags) ? $tag : 'h3');

	// Determine if days are set; if so, calculate start point
	if ($days) {
		$start = time() - ($days * 24 * 60 * 60);
	}

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$series = get_posts($args);

	// Build post
	$string = '';
	foreach ($series as $post) {
		setup_postdata($post);
		$posted = get_post_time('U', true);
	
		// Check time before displaying
		if (is_sticky() || ($days && $posted >= $start)) {
			$string = $string.'<div id="headline-post-'.get_the_ID().'" class="'.$class.'">'."\n\t"; // Open the container
			$string = $string.rucampi_concat_title($tag, $label, true, true); // The post
			$string = $string.'<div class="rcpi-more"><a href="'.get_permalink().'" title="read the full story">Read the story ...</a></div>'; // The post
			$string = $string."</div>\n".rucampi_return_clear($clear); // Close container and append div to clear, if set
		} // End check of time
	
	} // Next post
	
	apply_filters('rucampi_display_dated', $string);
	return $string;
	
} // End function
add_shortcode('headlinepost', 'rucampi_display_headline');

// Retrieves most recent published post and displays if post month is current month
function rucampi_display_monthly($atts, $content = null)
{
	global $post, $rcpi_post_orderbys, $rcpi_post_tags, $rcpi_post_types;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'post_type' => false,			// Post type
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 0,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-monthly-post',	// Class of post container
		'tag' => 'h3'					// Tag to use for post title
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$post_type = (in_array($post_type, $rcpi_post_types) ? $post_type : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, $rcpi_post_orderbys) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '1' || $thumb === 1 ? 1 : 0);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-monthly-post');
	$tag = (in_array($tag, $rcpi_post_tags) ? $tag : 'h3');

	// Get the current month and year
	$thismonth = date('n|Y', time());

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($post_type) {$args['post_type'] = $post_type;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$monthly = get_posts($args);

	// Build post if current month/year match post month/year
	$string = '';
	foreach ($monthly as $post) {
		setup_postdata($post); //
		$postmonth = date('n|Y', get_post_time('U', true));
	
		// Check time/sticky status before displaying
		if ($thismonth == $postmonth) {
			$string = $string.'<div id="monthly-post-'.get_the_ID().'" class="'.$class.'">'."\n\t"; // Open the container
			$string = $string.rucampi_concat_title($tag, $label, $title, $link).rucampi_concat_body($thumb, $excerpt, $postdate); // The post
			$string = $string."</div>\n".rucampi_return_clear($clear); // Close container and append div to clear, if set
		} // End check of time/sticky status
	
	} // Next post
	
	apply_filters('rucampi_display_monthly', $string);
	return $string;
	
} // End function
add_shortcode('monthlypost', 'rucampi_display_monthly');

// Retrieves and displays most recent posts; default is one post; ignores sticky post status
function rucampi_display_new($atts, $content = null)
{
	global $post, $rcpi_post_orderbys, $rcpi_post_tags, $rcpi_post_types;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'post_type' => false,			// Post type
		'number' => 1,					// Number of posts to display
		'offset' => false,				// Place at which to start; first post is 0
		'orderby' => false,				// Field to sort by
		'order' => false,				// Sort order; relevant only when multiple posts are returned
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-new-post',		// Class of post container
		'tag' => 'h3'					// Tag to use for post title
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$post_type = (in_array($post_type, $rcpi_post_types) ? $post_type : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$offset = (is_numeric($offset) && floor($offset) > 0 ? floor($offset) : false);
	$orderby = (in_array($orderby, $rcpi_post_orderbys) ? $orderby : false); 
	$order = ($order == 'ASC' ? $order : false);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-new-post');
	$tag = (in_array($tag, $rcpi_post_tags) ? $tag : 'h3');

	// Set function args and get the post
	$args = array('numberposts' => $number);
	if ($category) {$args['category'] = $category;}
	if ($post_type) {$args['post_type'] = $post_type;}
	if ($offset) {$args['offset'] = $offset;}
	if ($orderby) {$args['orderby'] = $orderby;}
	if ($order) {$args['order'] = $order;}
	$newposts = get_posts($args);
	
	// Build posts
	$string = '';
	foreach ($newposts as $post) {
		setup_postdata($post);
		$string = $string.'<div id="new-post-'.get_the_ID().'" class="'.$class.'">'."\n\t"; // Open the container
		$string = $string.rucampi_concat_title($tag, $label, $title, $link).rucampi_concat_body($thumb, $excerpt, $postdate); // The post
		$string = $string."</div>\n".rucampi_return_clear($clear); // Close container and append div to clear, if set
	} // Next post
	
	apply_filters('rucampi_display_new', $string);
	return $string;

} // End function
add_shortcode('newpost', 'rucampi_display_new');

// Displays a single random published post; ignores sticky post status
function rucampi_display_random($atts, $content = null)
{
	global $post,$rcpi_post_tags, $rcpi_post_types;

	// Get shortcode args
	extract(shortcode_atts(array(
		'category' => false,			// Designate the category; pulls from all categories if none is set
		'post_type' => false,			// Post type
		'number' => 1,					// Number of posts to display
		'label' => '',					// String to prefix title of post; appears before title's HTML tag
		'title' => 1,					// Display post tile: 1 is true, 0 is false
		'link' => 1,					// Link title to full post: 1 is true, 0 is false
		'excerpt' => 1,					// Display excerpt: 1 is true, 0 is false
		'thumb' => 1,					// Display thumbnail image: 1 is true, 0 is false
		'postdate' => 0,				// Display date of post: accepted values are 'time', 'date' and 0
		'clear' => 1,					// Whether to clear floats after the post
		'class' => 'rcpi-random-post',	// Class of post container
		'tag' => 'h3'					// Tag to use for post title
	), $atts));

	// Sanitize and set default values
	$category = (is_numeric($category) ? floor($category) : false);
	$post_type = (in_array($post_type, $rcpi_post_types) ? $post_type : false);
	$number = (is_numeric($number) && floor($number) > 0 ? floor($number) : 1);
	$title = ($title === '0' || $title === 0 ? 0 : 1);
	$link = ($link === '0' || $link === 0 ? 0 : 1);
	$excerpt = ($excerpt === '0' || $excerpt === 0 ? 0 : 1);
	$thumb = ($thumb === '0' || $thumb === 0 ? 0 : 1);
	$postdate = ($postdate == 'time' || $postdate == 'date' ? $postdate : 0);
	$clear = ($clear === '0' || $clear === 0 ? 0 : 1);
	$class = (trim($class) ? trim($class) : 'rcpi-random-post');
	$tag = (in_array($tag, $rcpi_post_tags) ? $tag : 'h3');

	// Set function args and get the post
	$args = array('numberposts' => $number, 'orderby' => 'rand');
	if ($category) {$args['category'] = $category;}
	if ($post_type) {$args['post_type'] = $post_type;}
	$random = get_posts($args);

	// Display random post
	$string = '';
	foreach ($random as $post) {
		setup_postdata($post);
		$string = $string.'<div id="random-post-'.get_the_ID().'" class="'.$class.'">'."\n\t"; // Open the container
		$string = $string.rucampi_concat_title($tag, $label, $title, $link).rucampi_concat_body($thumb, $excerpt, $postdate); // The post
		$string = $string."</div>\n".rucampi_return_clear($clear); // Close container and append div to clear, if set
	} // Next post
	
	apply_filters('rucampi_display_random', $string);
	return $string;
	
} // End function
add_shortcode('randompost', 'rucampi_display_random');
?>