<?php
// INCLUDE LIB FILES HERE ******************************************************************************
include('lib/options.php');
include('lib/options-functions.php');
include('lib/template-functions.php');
include('lib/content-format-functions.php');
include('lib/search-functions.php');
include('lib/theme-hooks.php');

// ENABLE THEME SUPPORT AND FUNCTIONS ******************************************************************
add_theme_support('post-thumbnails');
add_filter('widget_text', 'do_shortcode');

// DISABLE THEME SUPPORT AND BUILT-IN FEATURES *********************************************************
remove_shortcode('gallery', 'gallery_shortcode');

if (!function_exists('mfields_remove_gallery_setting_div')) {
	function mfields_remove_gallery_setting_div() {
		print '
			<style type="text/css">
				#gallery-form *, li#tab-gallery {display:none;}
			</style>';
	}
}
add_action('admin_head_media_upload_gallery_form', 'mfields_remove_gallery_setting_div');
add_action('admin_head_media_upload_type_form', 'mfields_remove_gallery_setting_div');
add_action('admin_head_media_upload_library_form', 'mfields_remove_gallery_setting_div');
add_action('admin_head_media_upload_type_url_form', 'mfields_remove_gallery_setting_div');

// REGISTER MENUS **************************************************************************************
function rucam_register_menus()
{
	register_nav_menus(array(
		'primary' => __('Main Navigation'),
	));
}
add_action('init', 'rucam_register_menus');

// REGISTER WIDGET AREAS *******************************************************************************
register_sidebar(array(
	'name' => 'Pre-Main',
	'id' => 'pre-main',
	'before_widget' => '<div id="%1$s" class="widget %2$s rc-pre-main">'."\n",
	'after_widget' => "</div>\n",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => "</h3>\n",
));

register_sidebar(array(
	'name' => 'Post-Main',
	'id' => 'post-main',
	'before_widget' => '<div id="%1$s" class="widget %2$s rc-post-main">'."\n",
	'after_widget' => "</div>\n",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => "</h3>\n",
));

register_sidebar(array(
	'name' => 'Bottom-Main',
	'id' => 'bottom-main',
	'before_widget' => '<div id="%1$s" class="widget %2$s rc-bottom-main">'."\n",
	'after_widget' => "</div>\n",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => "</h3>\n",
));

register_sidebar(array(
	'name' => 'Primary-Sidebar',
	'id' => 'primary-sidebar',
	'before_widget' => '<div id="%1$s" class="widget %2$s rc-primary-sidebar">'."\n",
	'after_widget' => "</div>\n",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => "</h3>\n",
));

register_sidebar(array(
	'name' => 'Inner-Sidebar',
	'id' => 'inner-sidebar',
	'before_widget' => '<div id="%1$s" class="widget %2$s rc-inner-sidebar">'."\n",
	'after_widget' => "</div>\n",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => "</h3>\n",
));

register_sidebar(array(
	'name' => 'Footer-Sidebar',
	'id' => 'footer-sidebar',
	'before_widget' => '<div id="%1$s" class="widget %2$s rc-footer-sidebar">'."\n",
	'after_widget' => "</div>\n",
	'before_title' => '<h3 class="widget-title">',
	'after_title' => "</h3>\n",
));
?>