<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head>

<?php if (is_front_page()) { rucam_meta_block(); } // Append meta tags from the options panel to the home page ?>
<meta http-equiv="content-type" content="text/html; charset=<?php bloginfo('charset'); ?>" />

<title><?php wp_title( '', true); // Page title
	if ($paged >= 2 || $page >= 2 ) { echo sprintf( __( ', Page %s', 'rucam-nouveau' ), max($paged, $page).' '); } // Paging
	echo (is_front_page() ? '' : ' | ');
	bloginfo('name'); // Site name
	echo (is_front_page() ? ', Rutgers University' : ''); // University name
	$rc_site_description = get_bloginfo('description', 'display'); // Tagline for home page only
	echo ($rc_site_description && (is_front_page()) ? " | ".$rc_site_description : ''); ?></title>
    
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo('stylesheet_directory'); ?>/css/default.css" />
<?php rucam_style_overrides(); // Combines output from various functions overriding default stylesheet ?>
<link rel="stylesheet" type="text/css" media="print" href="<?php bloginfo('stylesheet_directory'); ?>/css/print.css" />
<?php rucam_style_block(); // Append styles from the options panel ?>

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<script type="text/javascript" src="<?php bloginfo('stylesheet_directory'); ?>/js/site-functions.js"></script>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<!-- Begin page output -->
	<div id="rc-page-wrapper">
		<div id="rc-page-content">
  
			<!-- Begin header breadcrumb area -->
			<div id="rc-crumb-wrapper">
				<div id="rc-crumb-content">
					<div id="rc-crumb-skip"><a href="#skip" title="skip links"><img src="<?php bloginfo('stylesheet_directory'); ?>/images/s.gif" border="0" width="1" height="1" alt="skip to main content" /></a></div>
					<?php rucam_breadcrumbs(); ?>
					<div id="rc-search-link"><a href="http://search.rutgers.edu/" title="Search Rutgers University">Search Rutgers</a></div>
					<div class="rc-clearall"></div>
				</div>
			</div>
			<!-- End header breadcrumb area -->

			<!-- Begin header -->
			<div id="rc-header-wrapper">
				<div id="rc-header-content">
					<div id="rc-header-image"><?php rucam_logo_link(); ?></div>
					<h1 id="rc-header-text"><a href="<?php bloginfo('url'); ?>" title="<?php bloginfo('name'); ?> home"><?php echo esc_attr(get_bloginfo('name', 'display')); ?></a></h1>
					<?php rucam_subtitle(); ?>
				</div>
				<div class="rc-clearall"></div>
			</div>
			<!-- End header -->
    
			<!-- Begin top navigation -->
			<div id="rc-topnav-wrapper">
				<?php wp_nav_menu(array('container_id' => 'rc-topnav-content', 'menu_id' => 'rc-topnav-menu', 'theme_location' => 'primary')); ?>
				<div class="rc-clearall"></div>
			</div>
			<!-- End top navigation -->
    
			<!-- Begin page content -->
			<div id="rc-body-wrapper">
				<div id="rc-body-content">