<?php
// BEGIN FILTERS FOR POST FORMATTING *******************************************************************
// Replaces empty post title with "Untitled"
function rucampi_title($title)
{
	$title = trim($title);
	if (!$title || $title == 'Protected:' || $title == 'Private:') {
		$title = trim($title.' Untitled');
	}
	return $title;
} // End function

add_filter('the_title', 'rucampi_title');

// Appends "Read more" link to excerpts
function rucampi_excerpt_more($more)
{
	global $post;
	return ' ... <a href="'. get_permalink($post->ID) . '" title="read the full post">Read more ...</a>';
	
} // End function

add_filter('excerpt_more', 'rucampi_excerpt_more');

// Cleans up titles of archives for dates and authors
function rucampi_index_title($title)
{
	$title = trim(str_replace('&nbsp;', ' ', $title));
	
	if (is_year()) {
		return 'Archives for '.$title; // Year; no formatting, just extend title
	
	} else if (is_month() || is_day()) { // Month or day; rearrange and extend title
		$segments = explode(' ', $title);
		$segments = array_filter($segments);
		$year = trim(array_shift($segments));	
		$title = str_replace(' 0', ' ', implode(' ', $segments)); // Strip leading 0 from day
		return 'Archives for '.trim($title).(is_day() ? ', ' : ' ').$year;
	
	} else if (is_author()) {
		return 'Articles by '.$title; // Author; no formatting, just extend title
	
	} else { // Category or other title type
		return $title;
	}
} // End function

add_filter('wp_title', 'rucampi_index_title');


// BEGIN FUNCTIONS FOR HEADER AND FOOTER CONTENT *******************************************************
// Concats and displays the copyright line in the footer
function rucam_copyright()
{
	$string = '<div id="rc-copyright">Copyright <a href="'.wp_login_url(get_permalink()).'" title="log in">&copy;</a> '.rucam_copyright_date().' Rutgers, The State University of New Jersey. All rights reserved.</div>'."\n";
	
	apply_filters('rucam_copyright', $string);
	echo $string;
}

// Concats and displays the lastmod line in the footer
function rucam_lastmod()
{
	$string = '<div id="rc-lastmod">Page last updated by '.rucam_footer_credit();
	
	// No lastmod date available for 404 page, so ignore this page
	if (!is_404()) {
		$string = $string.' at ';
		if (function_exists('rucampi_datetime')) {
			$string = $string.rucampi_datetime(true, 'mod');
		} else {
			$string = $string.get_the_modified_time('g:i a F j, Y');
		}
	} // End check for 404
	
	$string = $string.".</div>\n";
	
	apply_filters('rucam_lastmod', $string);
	echo $string;
}

// BEGIN FUNCTIONS FOR GLOBAL CONTENT FORMATTTING ******************************************************
// Displays comments in custom format
function rucam_comments($comment, $args, $depth) {
   
   $GLOBALS['comment'] = $comment; 
?>
<li id="rc-comment-li-<?php comment_ID() ?>" <?php comment_class(); ?>>
	<div id="rc-comment-<?php comment_ID(); ?>">
		<div class="rc-comment-author"><strong><?php comment_author(); ?></strong> said at <?php echo rucam_comment_datetime(); ?>:
        	<span class="rc-comment-reply"><?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?></span>
        </div>
      
		<?php if ($comment->comment_approved == '0') : // Comment is not yet approved ?>
		<div class="rc-comment-pending">The comment is awaiting moderation.</div>
        <?php else : ?>
        <div class="rc-comment-text"><?php comment_text(); ?></div>
		<?php endif; // End check of comment approval ?>
        
        <div class="rc-clearall"></div>
	</div>
<?php
}

// Filters paging for multipage page or post content; adds span to style current page number
function rucam_link_pages()
{
	global $post;
	$output = wp_link_pages(array('before' => '<div class="rc-page-link"><span class="title">Pages:</span> ', 'after' => '</div>'."\n", 'echo' => 0));
	$output = preg_replace('/\s([0-9])/', ' <span class="current">$1</span>', $output, 1);
	echo $output;
}

// BEGIN FUNCTIONS FOR INDEX/ARCHIVE PAGE FORMATTTING **************************************************
function rucam_post_datetime($rc_datetime)
{
	echo $rc_datetime.(substr_count($rc_datetime, 'today') > 0 ? '' : ',');
}

// Displays post categories if categories are found
function rucam_category($rc_category)
{
	if ($rc_category) { 
		echo ' in ';
		the_category(', ');
	}
}

// Uses WP Paginate for pagination if plugin is available, default if not
function rucam_paginate()
{
	if (function_exists('wp_paginate')) {
		wp_paginate();
	} else {
?>
		<div class="rc-default-paging"><?php posts_nav_link(' | ', '&laquo; Previous results', 'Next results &raquo;'); ?></div>
<?php
	} // End check for function
}

// BEGIN FUNCTIONS FOR DATE/TIME HANDLING **************************************************************
// Uses AP style create date if plugin is available, default if not
function rucam_create_date()
{
	if (function_exists('rucampi_date')) {rucampi_date(false);} else {echo get_the_date();}
}
// Uses AP style create time if plugin is available, default if not
function rucam_create_time()
{
	if (function_exists('rucampi_time')) {rucampi_time(false);} else {echo get_the_time();}
}
// Uses AP style create datetime if plugin is available, default if not -- IN USE -- rucam_post_datetime()
function rucam_create_datetime()
{
	if (function_exists('rucampi_datetime')) {return rucampi_datetime(true);} else {return get_the_time().' '.get_the_date();}
}
// Uses AP style lastmod date if plugin is available, default if not
function rucam_mod_date()
{
	if (function_exists('rucampi_date')) {rucampi_date(true, 'mod');} else {the_modified_date();}
}
// Uses AP style lastmod time if plugin is available, default if not
function rucam_mod_time()
{
	if (function_exists('rucampi_time')) {rucampi_time(true, 'mod');} else {the_modified_time();}
}
// Uses AP style comment datetime if plugin is available, default if not -- IN USE -- rucam_comments()
function rucam_comment_datetime()
{
	if (function_exists('rucampi_datetime')) {return rucampi_datetime(true, 'comment');} else {return get_comment_time('g:i a F j, Y');}
}

?>