<?php
// GENERAL TAB THEME OPTION FUNCTIONS ******************************************************************
// Adds meta tags for the home page only to the head tags in header.php
function rucam_meta_block()
{
	$meta = trim(stripslashes(get_option('rc_meta_block')));
	
	// Test string to be sure it opens and closes with meta syntax and does not contain <style>, <link> or <script> tags
	if (substr($meta, 0, 5) == '<meta' && substr($meta, -2) == '/>' && substr_count($meta, '<style') == 0 && substr_count($meta, '<link') == 0 && substr_count($meta, '<script') == 0) {
		echo $meta."\n";
	}
}

// Adds styles to the head tags in header.php
function rucam_style_block()
{
	$styles = trim(stripslashes(get_option('rc_style_block')));
	
	// Test string to be sure it opens and closes with style syntax, contains at least one style and does not contain <meta>, <link> or <script> tags
	if (substr($styles, 0, 22) == '<style type="text/css"' && substr($styles, -8) == '</style>' && substr_count($styles, '{') > 0 && substr_count($styles, '}') > 0
		&& substr_count($styles, '<meta') == 0 && substr_count($styles, '<link') == 0 && substr_count($styles, '<script') == 0 ) {
		echo $styles."\n";
	}
}

// APPEARANCE TAB THEME OPTION FUNCTIONS ***************************************************************
// Concats other style-building functions to output a single stylesheet
function rucam_style_overrides()
{
	$schemes = rucam_color_schemes();
	$logo = rucam_logo();
	$widths = rucam_sidebar_variants();
	$thumbs = rucam_thumb_styles();
	
	if ($schemes || $logo || $widths || $thumbs) {
?>
<style type="text/css">
<?php echo $schemes.$logo.$widths.$thumbs; ?>
</style>
<?php
	}
}

// Builds styles to override the default sidebar width and position
function rucam_sidebar_variants()
{
	$psb_width = get_option('rc_psb_width');
	$psb_position = get_option('rc_psb_position');
	$psb_change_width = false;
	$isb_width = get_option('rc_isb_width');
	$styles = '';
	
	// Determine if primary sidebar width value is valid and different from default; set corresponding width for main content
	if ($psb_width && is_numeric($psb_width) && $psb_width != 25 && $psb_width >= 20 && $psb_width <= 35) {
		$psb_difference = 100 - $psb_width;
		$psb_change_width = true;
	}
	
	// If width and/or position values are not the defaults, build the styles
	if ($psb_change_width || $psb_position == 'right') {
		$styles = $styles."\t".'#rc-psb-wrapper {'.($psb_change_width ? 'width: '.$psb_width.'%; ' : '').($psb_position == 'right' ? 'float: right;' : '').'}'."\n";
		$styles = $styles."\t".'#rc-main-wrapper {'.($psb_change_width ? 'width: '.$psb_difference.'%; ' : '').($psb_position == 'right' ? 'float: right;' : '').'}'."\n";
		$styles = $styles.($psb_position == 'right' ? "\t".'#rc-main-outer-box {margin-right: 7px; margin-left: 0;}'."\n" : '');
		$styles = $styles."\t".'#rc-footer-widget-wrapper {'.($psb_change_width ? 'width: '.$psb_width.'%; ' : '').($psb_position == 'right' ? 'float: right;' : '').'}'."\n";
		$styles = $styles."\t".'#rc-pagedata-wrapper {'.($psb_change_width ? 'width: '.$psb_difference.'%; ' : '').($psb_position == 'right' ? 'float: right;' : '').'}'."\n";
		$styles = $styles.($psb_position == 'right' ? "\t".'#rc-footer-widget {margin: 0 20px 0 6px; padding-right: 0; padding-left: 20px;}'."\n" : '');
		$styles = $styles.($psb_position == 'right' ? "\t".'#rc-pagedata {margin: 0 9px 0 20px; padding-right: 20px; padding-left: 0;}'."\n" : '');
	}
	
	// Determine if inner sidebar width value is valid and different from default
	if ($isb_width && is_numeric($isb_width) && $isb_width != 30 && $isb_width >= 25 && $isb_width <= 45) {
		$styles = $styles."\t".'#rc-isb-wrapper {width: '.$isb_width.'%;}'."\n";
	}
			
	return $styles;
}

// Builds styles to override the color schemes of the top navbar, top page background, bottom page background and footer
function rucam_color_schemes()
{
	$nav = get_option('rc_navbar_style');
	$bottom = get_option('rc_body_bottom_style');
	$top = get_option('rc_body_top_style');
	$footer = get_option('rc_footer_style');
	$styles = '';
	
	if ($nav) {
		switch ($nav) {
			case 'light':
				$styles = $styles."\t".'#rc-topnav-wrapper {background: #e9e9e9 url('.get_bloginfo('stylesheet_directory', 'display').'/images/topNavBG-light.jpg) repeat; color: #454545;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu a {background-color: transparent; color: #000000;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu a:hover {background-color: transparent; color: #660000;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu ul a {background-color: #b8b8b8; color: #000000;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu ul a:hover {background-color: #b8b8b8; background-image: url('.get_bloginfo('stylesheet_directory', 'display').'/images/navSelected-red.png); color: #660000;}'."\n";				
				break;
			case 'medium':
				$styles = $styles."\t".'#rc-topnav-wrapper {background: #c2c2c2 url('.get_bloginfo('stylesheet_directory', 'display').'/images/topNavBG-medium.jpg) repeat; color: #3b3b3b;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu a {background-color: transparent; color: #000000;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu a:hover {background-color: transparent; color: #660000;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu ul a {background-color: #777777; color: #efefef;}'."\n";
				$styles = $styles."\t".'ul#rc-topnav-menu ul a:hover {background-color: #777777; color: #ffffff;}'."\n";
				break;
			default:
				$styles = $styles;
		} // End switch
	}
	
	if ($bottom) {
		switch ($bottom) {
			case 'light':
				$styles = $styles."\t".'body {background: #e9e9e9 url('.get_bloginfo('stylesheet_directory', 'display').'/images/pageBG-'.$bottom.'.jpg) repeat; color: #454545;}'."\n";
				break;
			case 'dark':
				$styles = $styles."\t".'body {background: #4f4f4f url('.get_bloginfo('stylesheet_directory', 'display').'/images/pageBG-'.$bottom.'.jpg) repeat; color: #cccccc;}'."\n";
				break;
			default:
				$styles = $styles;
		} // End switch
	}
	
	if ($top) {
		switch ($top) {
			case 'medium':
				$styles = $styles."\t".'#rc-body-wrapper {background: transparent url('.get_bloginfo('stylesheet_directory', 'display').'/images/bodyBG-'.$top.'.jpg) repeat-x; color: #3b3b3b;}'."\n";
				break;
			case 'dark':
				$styles = $styles."\t".'#rc-body-wrapper {background: transparent url('.get_bloginfo('stylesheet_directory', 'display').'/images/bodyBG-'.$top.'.jpg) repeat-x; color: #cccccc;}'."\n";
				break;
			default:
				$styles = $styles;
		} // End switch
	}
	
	if ($footer) {
		switch ($footer) {
			case 'light':
				$styles = $styles."\t".'#rc-footer-box {border: 1px solid #c1c1c1; background: #e9e9e9 url('.get_bloginfo('stylesheet_directory', 'display').'/images/contrastBG-'.$footer.'.jpg) repeat-x; color: #454545;}'."\n";
				$styles = $styles."\t".'#rc-footer-box a {color: #454545;}'."\n";
				$styles = $styles."\t".'#rc-footer-content.rc-default-style {background: transparent url('.get_bloginfo('stylesheet_directory', 'display').'/images/footerBG-light.png) no-repeat -5px -25px; color: inherit;}'."\n";
				break;
			case 'medium':
				$styles = $styles."\t".'#rc-footer-box {border: 1px solid #a0a0a0; background: #c2c2c2 url('.get_bloginfo('stylesheet_directory', 'display').'/images/contrastBG-'.$footer.'.jpg) repeat-x; color: #3b3b3b;}'."\n";
				$styles = $styles."\t".'#rc-footer-box a {color: #242424;}'."\n";
				$styles = $styles."\t".'#rc-footer-content.rc-default-style {background: transparent url('.get_bloginfo('stylesheet_directory', 'display').'/images/footerBG-medium.png) no-repeat -5px -25px; color: inherit;}'."\n";
				break;
			default:
				$styles = $styles;
		} // End switch
	}
	
	return $styles;
}

// Sets style for thumbs on archive pages
function rucam_thumb_styles()
{
	$thumbs = get_option('rc_thumb_style');
	$styles = '';
	
	// Check the selected thumb style
	if ($thumbs == 'icon') {
		$styles = $styles."\t".'.attachment-post-thumbnail {height: 88px; width: 88px; margin-right: 10px; border:0; float: left;}'."\n";
	} else {
		$styles = $styles."\t".'.attachment-post-thumbnail {height: 82px; width: 82px; margin-right: 10px; padding: 2px; border: 1px solid #cccccc; float: left;}'."\n";
	}
	
	return $styles;
}

// Builds style to override the default logo in the header
function rucam_logo()
{
	$logo = get_option('rc_header_logo');
	if ($logo && $logo != 'camden') {
		return "\t".'#rc-header-content {background: transparent url('.get_bloginfo('stylesheet_directory', 'display').'/images/header-'.$logo.'.jpg) no-repeat 7px 0;}'."\n";
	}
}

// Sets the Rutgers logo link and link title in the header
function rucam_logo_link()
{
		$logo = get_option('rc_header_logo');
		
		switch ($logo) {
			case 'rusig':
			case 'rufull':
			case 'ru':
				$url = 'http://www.rutgers.edu/';
				$title = 'Rutgers University home';
				$alt = 'Rutgers University';
				break;
			case 'nb';
				$url = 'http://nb.rutgers.edu/';
				$title = 'Rutgers-New Brunswick home';
				$alt = 'Rutgers-New Brunswick';
				break;
			case 'newark':
				$url = 'http://www.newark.rutgers.edu/';
				$title = 'Rutgers-Newark home';
				$alt = 'Rutgers-Newark';
				break;
			default:
				$url = 'http://www.camden.rutgers.edu/';
				$title = 'Rutgers-Camden home';
				$alt = 'Rutgers-Camden';
		} // End switch
?>
	<a href="<?php echo $url; ?>" title="<?php echo $title; ?>"><img src="<?php echo bloginfo('stylesheet_directory'); ?>/images/s.gif" border="0" width="250" height="60" alt="<?php echo $alt; ?>" /></a>
<?php
}

// HEADER TAB THEME OPTION FUNCTIONS *******************************************************************
function rucam_breadcrumbs()
{
	$crumbs = trim(stripslashes(get_option('rc_breadcrumbs')));
	if ($crumbs) {
?>
        <div id="rc-crumb-links"><?php echo $crumbs; ?></div>
<?php
	} else {
?>
        <div id="rc-crumb-links"><a href="http://www.rutgers.edu/" title="Rutgers University home">Rutgers Home</a> &raquo; <a href="http://www.camden.rutgers.edu/" title="Rutgers-Camden home">Rutgers-Camden</a></div>	
<?php		
	} // End check of $crumbs
}

// Displays site subtitle in header if one is set
function rucam_subtitle()
{
	$subtitle = trim(stripslashes(get_option('rc_subtitle')));
	if ($subtitle) {
?>
        <div id="rc-subheader-text"><?php echo $subtitle; ?></div>
<?php
	} // End check of $subtitle
}

// FOOTER TAB THEME OPTION FUNCTIONS *******************************************************************
// Sets the copyright date or date range in footer.php
function rucam_copyright_date()
{
	$startyear = get_option('rc_copy_start');
	$thisyear = date('Y');
	
	if (is_numeric($startyear) && strlen($startyear) == 4 && $startyear < $thisyear) {
		return $startyear.'-'.$thisyear;
	} else {
		return $thisyear;
	}
}

// Returns the "last updated by" credit in footer.php
function rucam_footer_credit()
{
	$credit = get_option('rc_footer_credit');
	
	if ($credit) {
		return $credit;
	} else {
	 	return get_bloginfo('name', 'display');
	}
}

// ADVANCED TAB THEME OPTION FUNCTIONS *****************************************************************
// Disables wpautop() function, which may cause HTML validation and line-break formatting failures
function rucam_wpautop()
{
	$disable = get_option('rc_wpautop');
	if ($disable == 'true') {
		remove_filter('the_content', 'wpautop');
		remove_filter('the_excerpt', 'wpautop');
	}
}
rucam_wpautop(); // Call the function

// Sets display of author on archive and single pages: do not display, display name or display name with link
function rucam_author()
{
	$author = get_option('rc_post_author');
	$name = get_the_author();
	
	if ($author && $name) {
		switch ($author) {
			case 'name':
				echo ' by ';
				the_author(); 
				break;
			case 'link':
				echo ' by ';
				the_author_posts_link();
				break;
		} // End switch
	}
}

// Activates Google Analytics code if valid key found; ignores non-published and SSL pages
function rucam_analytics()
{
	global $post;
	$status = get_post_status();
	$protected = (empty($post->post_password) ? false : true);
	$ssl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? true : false);
	$key = get_option('rc_google_analytics');
	
	// Check for valid key and correct page status
	if (strlen($key) > 6 && substr_count($key, '-') == 2 && $status == 'publish' && !$protected && !$ssl) {
?>
<!-- Begin Google Analytics code -->
<script type="text/javascript"> 
	var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
	document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
</script>
<script type="text/javascript">
try {
	var pageTracker = _gat._getTracker("<?php echo $key; ?>");
	pageTracker._trackPageview();
} catch(err) {}
</script>
<!-- End Google Analytics code -->
<?php
	} // End check for key
}
add_action('wp_footer', 'rucam_analytics');
?>