<?php
$themename = 'RUCam Nouveau';
$shortname = 'rc';
$option_tabs = array('app' => 'Appearance', 'head' => 'Header', 'foot' => 'Footer', 'side' => 'Sidebar', 'meta' => 'Meta &amp; Analytics', 'adv' => 'Advanced');
$options = array(
			
	array(	'name' => __('Sitewide Style Block'),
			'desc' => __('Add styles to the site. The first line must be &lt;style type="text/css"&gt; and the last line must be &lt;/style&gt;.'),
			'id' => $shortname.'_style_block',
			'std' => '',
			'type' => 'textarea',
			'options' => array('rows' => 10, 'cols' => 100),
			'tab' => 'app'),
			
	array(	'name' => __('Header Logo'),
			'desc' => __('Select a header logo. If not set, the Rutgers-Camden logo will be displayed.'),
			'id' => $shortname.'_header_logo',
			'std' => '',
			'type' => 'select',
			'options' => array('rusig' => 'Rutgers (Signature Only)', 'rufull' => 'Rutgers (Full Name)', 'ru' => 'Rutgers University', 
				'camden' => 'Rutgers-Camden', 'nb' => 'Rutgers-New Brunswick', 'newark' => 'Rutgers-Newark'),
			'tab' => 'app'),
			
	array(	'name' => __('Nav Bar Color Scheme'),
			'desc' => __('Select a color scheme for the main navigation bar. The default scheme is Dark.'),
			'id' => $shortname.'_navbar_style',
			'std' => '',
			'type' => 'select',
			'options' => array('light' => 'Light', 'medium' => 'Medium', 'dark' => 'Dark'),
			'tab' => 'app'),
			
	array(	'name' => __('Top Body Color Scheme'),
			'desc' => __('Select a color scheme for the top body background. The default scheme is Light.'),
			'id' => $shortname.'_body_top_style',
			'std' => '',
			'type' => 'select',
			'options' => array('light' => 'Light', 'medium' => 'Medium', 'dark' => 'Dark'),
			'tab' => 'app'),
			
	array(	'name' => __('Bottom Body Color Scheme'),
			'desc' => __('Select a color scheme for the bottom body background. The default scheme is Medium.'),
			'id' => $shortname.'_body_bottom_style',
			'std' => '',
			'type' => 'select',
			'options' => array('light' => 'Light', 'medium' => 'Medium', 'dark' => 'Dark'),
			'tab' => 'app'),
			
	array(	'name' => __('Footer Color Scheme'),
			'desc' => __('Select a color scheme for the page footer. The default scheme is Dark.'),
			'id' => $shortname.'_footer_style',
			'std' => '',
			'type' => 'select',
			'options' => array('light' => 'Light', 'medium' => 'Medium', 'dark' => 'Dark'),
			'tab' => 'app'),
			
	array(	'name' => __('Thumbnail Image Style'),
			'desc' => __('Set the styles for thumbnail images on archive pages. The default is bordered.'),
			'id' => $shortname.'_thumb_style',
			'std' => 'photo',
			'type' => 'radio',
			'options' => array('photo' => 'Bordered (for photos)', 'icon' => 'Open (for photo objects, icons and images with custom borders)'),
			'tab' => 'app'),
			
	array(	'name' => __('Header Breadcrumbs'),
			'desc' => __('Use custom breadcrumbs in the header. If not set, the default of Rutgers Home &raquo; Rutgers-Camden will be used.'),
			'id' => $shortname.'_breadcrumbs',
			'std' => '',
			'type' => 'textarea',
			'options' => array('rows' => 7, 'cols' => 100),
			'tab' => 'head'),
			
	array(	'name' => __('Site Subtitle'),
			'desc' => __('Add subtitle to appear below the department (blog) name. If not set, no subtitle will be displayed.'),
			'id' => $shortname.'_subtitle',
			'std' => '',
			'type' => 'textarea',
			'options' => array('rows' => 7, 'cols' => 100),
			'tab' => 'head'),
			
	array(	'name' => __('Copyright Start Year'),
			'desc' => __('Set a start year for the footer copyright if a date range is to be displayed. If not set, the current year will be displayed as the copyright date.'),
			'id' => $shortname.'_copy_start',
			'std' => '',
			'type' => 'text',
			'tab' => 'foot'),
			
	array(	'name' => __('Footer Credit'),
			'desc' => __('Set the \'last updated by\' credit in the footer. If not set, the blog name will be used.'),
			'id' => $shortname.'_footer_credit',
			'std' => '',
			'type' => 'text',
			'tab' => 'foot'),
			
	array(	'name' => __('Primary Sidebar Width'),
			'desc' => __('Enter a whole number between 20 and 35 to change the width as a percentage of the page width. If not set, the default of 25 will be used.'),
			'id' => $shortname.'_psb_width',
			'std' => '',
			'type' => 'text',
			'tab' => 'side'),
			
	array(	'name' => __('Primary Sidebar Location'),
			'desc' => __('Set the location of the primary sidebar. The default is left.'),
			'id' => $shortname.'_psb_position',
			'std' => 'left',
			'type' => 'radio',
			'options' => array('left' => 'Left sidebar', 'right' => 'Right sidebar'),
			'tab' => 'side'),
			
	array(	'name' => __('Inner Sidebar Width'),
			'desc' => __('Enter a whole number between 25 and 45 to change the width as a percentage of the page width. If not set, the default of 30 will be used.'),
			'id' => $shortname.'_isb_width',
			'std' => '',
			'type' => 'text',
			'tab' => 'side'),
			
	array(	'name' => __('Home Meta Block'),
			'desc' => __('Add meta tags to the home page. If not set, only the sitewide character encoding tag will be used.'),
			'id' => $shortname.'_meta_block',
			'std' => '',
			'type' => 'textarea',
			'options' => array('rows' => 7, 'cols' => 100),
			'tab' => 'meta'),
			
	array(	'name' => __('Google Analytics Key'),
			'desc' => __('Add a valid key to activate Google Analytics code. Leave blank if Google Analytics is not in use.'),
			'id' => $shortname.'_google_analytics',
			'std' => '',
			'type' => 'text',
			'tab' => 'meta'),
			
	array(	'name' => __('Designate Search Page'),
			'desc' => __('Add a search page to the site by creating a page using the Search Page template and entering the page ID here.'),
			'id' => $shortname.'_search_page',
			'std' => '',
			'type' => 'text',
			'tab' => 'adv'),
			
	array(	'name' => __('Display Post Author'),
			'desc' => __('Display the author of posts on archive and single pages. The default is no display.'),
			'id' => $shortname.'_post_author',
			'std' => '0',
			'type' => 'radio',
			'options' => array('0' => 'Do not display author', 'name' => 'Display author without link', 'link' => 'Display and link author'),
			'tab' => 'adv'),
			
	array(	'name' => __('Disable wpautop() Function'),
			'desc' => __('Disable the wpautop() function that adds paragraph tags and line breaks to content. Use only when tag stripping is disabled.'),
			'id' => $shortname.'_wpautop',
			'std' => '',
			'type' => 'checkbox',
			'options' => array('true' => 'Disable Function'),
			'tab' => 'adv')
);

function rucam_admin()
{
	global $themename, $shortname, $option_tabs, $options;
	
	if ($_REQUEST['saved']) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ($_REQUEST['reset']) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
	
	$tab = (isset($_GET["tab"]) && !empty($_GET["tab"]) ? $_GET["tab"] : 'app');
	$selected_options = array();
?>
	<div class="wrap">
    	<h2><?php echo $themename; ?> Options</h2>
        <p id="tabs" class="options" style="padding: 7px; background-color: #f8f8f8;">
<?php 
	$ocount = 0;
	foreach ($option_tabs as $okey => $ovalue) {
?>
		<a href="themes.php?page=options.php&tab=<?php echo $okey; ?>"><?php echo strtoupper($ovalue); ?></a> <?php echo ($ocount < count($option_tabs)-1 ? ' - ' : ''); ?>
<?php
		$ocount++;
	} // Next tab link
?>
        </p>
        <h3><?php echo $option_tabs[$tab]; ?> Options</h3>
        <!-- Update options form -->
        <form method="post">
        	
			<?php wp_nonce_field('rucam-nouveau-save'); ?>
            <table class="form-table">
            
			<?php foreach ($options as $value) {
				
				if ($tab == $value['tab']) {
				
					// Output the form element
					switch ($value['type']) {
					
						case 'text';
?>
            	<tr valign="top">
                	<th scope="row"><?php echo $value['name']; ?>:</th>
                    <td>
                    <?php echo $value['desc']; ?><br />
                    <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="text" size="30" value="<?php echo esc_textarea(stripslashes(get_option($value['id'], $value['std']))); ?>" />
                    </td>
            	</tr>
<?php
							break; // End text
						
						case 'select';
?>
            	<tr valign="top">
                	<th scope="row"><?php echo $value['name']; ?>:</th>
                    <td>
                    <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
                    	<option value="">--</option>
<?php
							foreach ($value['options'] as $key => $option) {
?>
                    	<option value="<?php echo $key; ?>" <?php echo ($key == get_option($value['id'], $value['std']) ? 'selected="selected"' : ''); ?>><?php echo $option; ?></option>
<?php
							} // Next select option
?>
                    </select>
                    <?php echo $value['desc']; ?>
                    </td>
            	</tr>
<?php
							break; // End select
						
						case 'textarea';
						$ta_options = $value['options'];
?>
            	<tr valign="top">
                	<th scope="row"><?php echo $value['name']; ?>:</th>
                    <td>
                    <?php echo $value['desc']; ?><br />
                    <textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="<?php echo $ta_options['cols']; ?>" 
                    	rows="<?php echo $ta_options['rows']; ?>"><?php echo esc_textarea(stripslashes(get_option($value['id'], $value['std']))); ?></textarea>
                    </td>
            	</tr>
<?php					
							break; // End textarea
						
						case 'radio';
?>
            	<tr valign="top">
                	<th scope="row"><?php echo $value['name']; ?>:</th>
                    <td>
<?php
							echo $value['desc'].'<br />';
							foreach ($value['options'] as $key => $option) {
?>
						<input name="<?php echo $value['id']; ?>" type="radio" value="<?php echo $key; ?>" <?php echo ($key == get_option($value['id'], $value['std']) ? 'checked="checked"' : ''); ?> /> <?php echo $option; ?><br />
<?php
							} // Next radio button
?>                    
                    </td>
            	</tr>
<?php
							break; // End radio
						
						case 'checkbox';
?>
            	<tr valign="top">
                	<th scope="row"><?php echo $value['name']; ?>:</th>
                    <td>
<?php
							echo $value['desc'].'<br />'; 
							foreach ($value['options'] as $key => $option) {
?>
                    <input name="<?php echo $value['id']; ?>" id"<?php echo $value['id']; ?>" type="checkbox" value="true" <?php echo ($key == get_option($value['id'], $value['std']) ? 'checked="checked"' : ''); ?> /> <?php echo $option; ?><br />                         
<?php
							} // Next checkbox
?> 
                    </td>
            	</tr>
<?php
							break; // End checkbox
						
						default:
							break;
											
					} // End switch
				} // End check against $tab value
			} // Next option
			?>
            
            </table>
            
            <p class="submit"><input name="save" type="submit" value="Save changes" class="button-primary" /> <input type="hidden" name="action" value="save" /></p> 
        </form>
        
        <!-- Reset options form -->
        <form method="post">
        
        	<?php wp_nonce_field('rucam-nouveau-reset'); ?>
            
            <p class="submit"><input name="reset" type="submit" value="Reset Theme Options" /> <input type="hidden" name="action" value="reset" /></p>
        </form>
<?php
}

function rucam_add_admin()
{
	global $themename, $shortname, $options;
	$tab = (isset($_GET["tab"]) && !empty($_GET["tab"]) ? $_GET["tab"] : 'app');
	
	$page = (isset($_GET["page"]) && !empty($_GET["page"]) ? $_GET["page"] : '');
	if ($page == basename(__FILE__)) {
		
		$action = (isset($_REQUEST["action"]) && !empty($_REQUEST["action"]) ? $_REQUEST["action"] : '');
		if ($action == 'save') {
			 
			check_admin_referer('rucam-nouveau-save');
			 
			// If option value is set, save it; otherwise, delete it
			// Only update/delete items for the specified tab
			foreach ($options as $value) {
				if ($tab == $value['tab']) {
					if (isset($_REQUEST[$value['id']])) {
						update_option($value['id'], $_REQUEST[$value['id']]);
					} else {
						delete_option($value['id']);
					}
				} // End check against $tab value
			} // Next $options
			
			header("Location: themes.php?page=options.php&saved=true&tab=".$tab); // set the header value
			die;
			 
		} else if ($action == 'reset') {
			
			check_admin_referer('rucam-nouveau-reset');
			
			// Delete the options on reset
			foreach ($options as $value) {
				delete_option($value['id']);
			}
			
			header("Location: themes.php?page=options.php&reset=true&tab=".$tab); // set the header value
			die;
			
		} // End check of $action value
	} // End check of $page value
	
	add_theme_page($themename.' Options', $themename.' Options', 'edit_themes', basename(__FILE__), 'rucam_admin');
} // End function

add_action('admin_menu', 'rucam_add_admin');
?>