<?php
// TEMPLATE-ARCHIVES-YEAR.PHP FUNCTIONS ****************************************************************
function rucam_nested_archive()
{
	// Get years in archive
	$years = wp_get_archives(array('type' => 'yearly', 'format' => 'custom', 'show_post_count' => 1, 'echo' => 0));
	
	// Format array of years for display; remove empty items
	$allyears = array_map('trim', explode("\n", $years));
	$allyears = array_filter($allyears);
	
	// Create and sanitize array of yeears for search; filter empty items
	$findyears = array_map('trim', explode("\n", strip_tags($years)));
	$findyears = array_filter($findyears);
	
	// Get months in archive; format array of months for display; filter empty items
	$months = wp_get_archives(array('type' => 'monthly', 'format' => 'custom', 'show_post_count' => 1, 'echo' => 0));
	$allmonths = array_map('trim', explode("\n", $months));
	$allmonths = array_filter($allmonths);
	
	// Begin output of years
	for ($i=0; $i < count($allyears); $i++) {
		
		$year = substr($findyears[$i], 0, 4);
		echo '<li id="rc-year-'.$year.'">'.str_replace('&nbsp;', ' ', $allyears[$i])."\n<ul class=\"rc-year-child\">\n";
		
		// Begin output of months; if year found in month, display
		for ($ii = count($allmonths)-1; $ii > -1; $ii--) {
			if  (substr_count($allmonths[$ii], ' '.$year) > 0) {
				echo '<li>'.str_replace(' '.$year.'</a>&nbsp;', '</a> ', $allmonths[$ii])."</li>\n";
			}
		} // Next month
		
		// Close list before moving to next year
		echo "</ul>\n</li>\n";
	} // Next year
}

// TEMPLATE-FEEDS-AUTHOR.PHP FUNCTIONS *****************************************************************
/* Retrieve list of feeds, modify HTML and display */
function rucam_feeds_author()
{
	$img = get_bloginfo('stylesheet_directory').'/images/icons/rss-small.png';
	$authors = wp_list_authors(array('feed' => 'RSS', 'feed_text' => 'RSS', 'feed_image' => $img, 'echo' => 0));
	$list = explode("</li>", $authors);
	
	$i = 0;
	foreach ($list as $author) {
		if (trim($author)) {
			$author = str_replace('<li>', '<li class="child-'.($i % 2).'">', $author);
			echo $author.'<div class="rc-clearall"></div></li>'."\n";
			$i++;
		} // End check for empty item
	} // Next author
}

// TEMPLATE-FEEDS-CATEGORY.PHP FUNCTIONS ***************************************************************
/* Retrieve list of feeds, modify HTML and display */
function rucam_feeds_category()
{
	$img = get_bloginfo('stylesheet_directory').'/images/icons/rss-small.png';
	$categories = wp_list_categories(array('title_li' => '', 'hierarchical' => 0, 'feed' => 'RSS', 'feed_text' => 'RSS', 'feed_image' => $img, 'echo' => 0));
	$list = explode("</li>", $categories);
	
	$i = 0;
	foreach ($list as $category) {
		if (trim($category)) {
			$category = str_replace('<li class="', '<li class="child-'.($i % 2).' ', $category);
			echo $category.'<div class="rc-clearall"></div></li>'."\n";
			$i++;
		} // End check for empty item
	} // Next category
}

// TEMPLATE-LINKS.PHP FUNCTIONS ************************************************************************
// Uses My Link Order to order links and categories if plugin is available, default if not
function rucam_list_bookmarks()
{
	if (function_exists('mylinkorder_list_bookmarks')) {
		mylinkorder_list_bookmarks(array(
			'orderby' => 'order', 
			'category_orderby' => 'order', 
			'title_before' => '<h3 class="rc-category-title">', 
			'title_after' => '</h3>', 
			'category_before' => '<div id="%id" class="%class">'."\n", 
			'category_after' => '</div>'."\n"
		)); 
	} else {
		wp_list_bookmarks(array(
			'title_before' => '<h3 class="rc-category-title">', 
			'title_after' => '</h3>', 
			'category_before' => '<div id="%id" class="%class">'."\n", 
			'category_after' => '</div>'."\n"
		));
	} // End check for function
}

// TEMPLATE-NOSIDEBAR.PHP FUNCTIONS ********************************************************************
// Add class to change page width if primary sidebar is inactive or no-sidebar template is used
function rucam_pagewidth() 
{
	$sidebar = is_active_sidebar('primary-sidebar');
	$nosidebar = is_page_template('template-nosidebar.php');
	if (!$sidebar || $nosidebar) {
		echo 'class="rc-full-width"';
	}
}
?>