<?php
// DECLARE SCARLET SITE SETTINGS ***********************************************************************
$scarlet_site_settings = array(
	array(	
		'name' => __('Fill Empty Titles'),
		'desc' => __('Fill blank page and post titles with "Untitled" wherever the title field is displayed. Adds a filter to the_title().'),
		'id' => 'fill_title',
		'default' => 'true',
		'type' => 'checkbox',
		'options' => array('true' => 'Fill Empty Page/Post Titles')),
		
	array(	
		'name' => __('Clean Up Archive Titles'),
		'desc' => __('Reformat titles for archives by date and author for cleaner presentation. Adds a filter to wp_title().'),
		'id' => 'clean_title',
		'default' => 'true',
		'type' => 'checkbox',
		'options' => array('true' => 'Clean Up Archive Titles')),
		
	array(	
		'name' => __('Add "Read More" Link'),
		'desc' => __('Append a "Read More" link to post excerpts if the post is longer than the excerpt. Adds a filter to excerpt_more().'),
		'id' => 'read_more',
		'default' => 'true',
		'type' => 'checkbox',
		'options' => array('true' => 'Add "Read More" Link')),
		
	array(
		'name' => __('Disable wpautop() Function'),
		'desc' => __('Disable the wpautop() function that adds paragraph tags and line breaks to content. Enable this only when tag stripping is disabled in TinyMCE.'),
		'id' => 'wpautop',
		'default' => '',
		'type' => 'checkbox',
		'options' => array('true' => 'Disable Function')),
		
	array(
		'name' => __('Fix Double Spacing'),
		'desc' => __('Remove double spacing in posts and pages (after periods, colons, etc.) for cleaner content display.'),
		'id' => 'double_spacing',
		'default' => '',
		'type' => 'checkbox',
		'options' => array('true' => 'Fix Double Spacing')),
		
	array(	
		'name' => __('Google Analytics Key'),
		'desc' => __('Add a valid key to activate Google Analytics code. Leave blank if Google Analytics is not in use.'),
		'id' => 'google_analytics',
		'default' => '',
		'type' => 'text')
);

// BEGIN FUNCTIONS TO DISPLAY SETTINGS PAGE ************************************************************
// Add settings page to Settings menu
function add_scarlet_site_options_page() {
	add_options_page('Scarlet Site', 'Scarlet Site', 'manage-options', 'scarlet-site', 'scarlet_site_options_page');
}
add_action('admin_menu', 'add_scarlet_site_options_page');

// Set up settings page code
function scarlet_site_options_page() {
	
	global $scarlet_site_settings;
?>
	<div class="wrap">
		<?php screen_icon(); ?>
		<h2>Scarlet Site Options</h2>
		<form action="options.php" method="post">
    	<?php settings_fields('scarlet_site_options'); ?>
      <?php do_settings_sections('scarlet_site'); ?>
			<table class="form-table">
      <?php foreach ($scarlet_site_settings as $scarlet_site_setting) { ?>
				<tr valign="top">
					<th scope="row"><?php echo $scarlet_site_setting['name']; ?>:</th>
					<td><?php echo $scarlet_site_setting['desc']; ?><br /><?php call_user_func('scarlet_site_'.$scarlet_site_setting['type'], $scarlet_site_setting); ?></td>
				</tr>
      <?php } // Next setting ?>
			</table>
      <p class="submit"><input name="Submit" type="submit" value="<?php esc_attr_e('Save Changes'); ?>" /></p>
		</form>
    <pre><?php $check_my_options = get_alloptions(); print_r($check_my_options); ?></pre>
	</div>
<?php
}

// BEGIN FUNCTIONS TO REGISTER SETTINGS AND DISPLAY FORM FIELDS ****************************************
// Loop through settings array, register setting and display corresponding form field
function scarlet_site_init() {
	
	global $scarlet_site_settings;
	
	foreach ($scarlet_site_settings as $scarlet_site_setting) {
		register_setting('scarlet_site_options', $scarlet_site_setting['id']);
	} // Next	setting
	add_settings_section('scarlet_site_main', '', 'scarlet_site_section', 'scarlet-site');
}
add_action('admin_init', 'scarlet_site_init'); 

// Display settings section content
function scarlet_site_section() {
}

// Display text field
function scarlet_site_text($setting) {
	
	$id = $setting['id']; echo $id.'<br>';
	$options = get_option('scarlet_site_options');
	$value = (isset($options[$id]) ? $options[$id] : $setting['default']); echo $value;
?>
	<input name="<?php echo $id; ?>" id="<?php echo $id; ?>" type="text" size="30" value="<?php echo esc_textarea(stripslashes($value)); ?>" />
<?php	
}

// Display checkboxes
function scarlet_site_checkbox($setting) {
	
	$id = $setting['id'];
	$options = get_option('scarlet_site_options');
	
	foreach ($setting['options'] as $value => $label) {
	
		$checkval = (isset($options[$id]) ? $options[$id] : array());
?>
	<input name="<?php echo $id; ?>>[]" id="<?php echo $id.'_'.$value; ?>" type="checkbox" value="true" <?php echo (in_array($value, $checkval) ? 'checked="checked"' : ''); ?> /> <?php echo $label; ?>
<?php
	} // Next checkbox
}
?>