<?php
/*
Plugin Name: Scarlet Summary
Description: Gets a list of sites with the template and plugin each is using.
Version: 1.0
Author: Susan Walker
Author URI: http://computing.camden.rutgers.edu
License: Copyright 2011 Rutgers University. For use on Rutgers Wordpress sites. Not for general release.
*/

function scarlet_summary_options_page()
{

	global $wpdb;
	$scarlet_summary_blogs = $wpdb->get_results("SELECT blog_id FROM wp_blogs ORDER BY blog_id", ARRAY_A);
	$scarlet_summary_sql = '';

	foreach ($scarlet_summary_blogs as $scarlet_summary_blog) {
		$scarlet_summary_sql = $scarlet_summary_sql."(SELECT blogname, template, active_plugins FROM wp_".$scarlet_summary_blog['blog_id']."_options) UNION ";
	} // Next blog ID
	
	$scarlet_summary_sql = strrev($scarlet_summary_sql);
	$scarlet_summary_sql = substr($scarlet_summary_sql, 7);
	$scarlet_summary_sql = strrev($scarlet_summary_sql);
		
	$scarlet_summary_fields = $wpdb->get_results($scarlet_summary_sql, ARRAY_A);

	foreach ($scarlet_summary_fields as $scarlet_summary_field) {
?>
	<p><?php echo $scarlet_summary_field['blogname'];?><br />
		<?php echo $scarlet_summary_field['template'];?><br />
		<?php echo $scarlet_summary_field['active_plugins'];?><br /></p>
<?php
	} // Next blog
}

// BEGIN FUNCTIONS TO ADD SETTINGS PAGE TO ADMIN MENU **************************************************
function add_scarlet_summary_options_page() {
	add_submenu_page('sites.php', 'Site Summary', 'Site Summary', 'manage_sites', 'scarlet-summary', 'scarlet_summary_options_page');
}
add_action('network_admin_menu', 'add_scarlet_summary_options_page');
?>